﻿#$baseURL = "https://192.168.2.136:4450/admin"
#$baseURL = "https://192.168.100.165:4450/admin"
$baseURL = "https://10.91.160.135:4450/admin"
$AdminUser = "admin"
$password = "alaska"

# Only to ignore certificates errors
add-type @"
    using System.Net;
    using System.Security.Cryptography.X509Certificates;

        public class IDontCarePolicy : ICertificatePolicy {
        public IDontCarePolicy() {}
        public bool CheckValidationResult(
            ServicePoint sPoint, X509Certificate cert,
            WebRequest wRequest, int certProb) {
            return true;
        }
    }
"@
[System.Net.ServicePointManager]::CertificatePolicy = new-object IDontCarePolicy 
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12


# authentication
$authBody = "{""userName"": ""$AdminUser"", ""password"": ""$password"", ""authType"": ""EFT""}"
$auth = Invoke-RestMethod -Uri "$baseURL/v1/authentication" -Method 'POST' -Body $authBody

$authToken = $auth.authToken
$authHeader = New-Object "System.Collections.Generic.Dictionary[[String],[String]]"
$authHeader.Add("Authorization", "EFTAdminAuthToken $authToken")


# get sites
Write-Output "Site"
Write-Output "----"
$siteList = Invoke-RestMethod -Uri "$baseURL/v2/sites" -Method 'GET' -Headers $authHeader
Write-Output $siteList | ConvertTo-Json
foreach ($site in $siteList.data)
{
    Write-Output ("Site  $($site.id): $($site.attributes.name)")
}

$siteID = $siteList.data[0].id

###
#Get Site Custom Commands
Write-Output "Get Site Custom Commands"
Write-Output "-----"
$serverAdminDetails = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/custom-commands" -Method 'GET' -Headers $authHeader
Write-Output $serverAdminDetails | ConvertTo-Json -Depth 10
##

###
#POST new site Custom Command
Write-Output "POST Custom Command (New Custom Command)"
Write-Output "-----"
$update = 
'{
    "data":{
        "id":"",
        "type": "customCommand",
            "attributes": {
                "enabled": true,
                "name": "Command 5",
                "description": "this is a test to run command 5",
                "executable": "c:\\windows\\system32\\cscript.exe \"c:\\users\\administrator\\desktop\\server.vbs\"",
                "parameters": "",
                "redirectOutputToLog": true,
                "useProcessTimeOut": true,
                "processTimeOut": 30,
                "logFileName": "C:\\ProgramData\\Globalscape\\EFT Server\\Logs\\cmdout.log",
                "redirectOutputToClient": true,
                "useMinNumOfParams": false,
                "minNumOfParams": 1,
                "minNumOfParamsMsg": ""
            }
    }
}'

$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 10
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/custom-commands" -Method 'POST' -Headers $authHeader -Body $update




###
#Get Site Custom Commands
Write-Output "Get Site Custom Commands"
Write-Output "-----"
$commands = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/custom-commands" -Method 'GET' -Headers $authHeader
#Write-Output $serverAdminDetails | ConvertTo-Json -Depth 10
foreach ($commands in $commands.id)
{
    Write-Output ("Custom Command found:  $($commands.id): $($commands.attributes.name)")
}
$customCommandID = $commands.data[0].id

###
#Get Custom Command
Write-Output "Get Custom Commands for: "  $customCommandID
Write-Output "-----"
$commandList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/custom-commands/$customCommandID" -Method 'GET' -Headers $authHeader
Write-Output $commandList | ConvertTo-Json -Depth 10


############################
#Patch a Custom Command
###
#Get Site Custom Commands
Write-Output "Get Site Custom Commands in order to Patch"
Write-Output "-----"
$commands = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/custom-commands" -Method 'GET' -Headers $authHeader
#Write-Output $serverAdminDetails | ConvertTo-Json -Depth 10
foreach ($commands in $commands.id)
{
    Write-Output ("Custom Command found:  $($commands.id): $($commands.attributes.name)")
}
$customCommandID = $commands.data[0].id

#PATCH Custom Command
Write-Output "Custom Command Patch"
Write-Output "Custom Command: $customCommandID"
Write-Output "-----"
$update = 
'{
    "data":{
        "id":"",
        "type": "customCommand",
            "attributes": {
                "enabled": true,
                "name": "Updated Custom Command Name 2",
                "description": "Updated Custom Command Description 2",
                "executable": "c:\\windows\\system32\\cscript.exe \"c:\\users\\administrator\\desktop\\server.vbs\"",
                "parameters": "",
                "redirectOutputToLog": true,
                "useProcessTimeOut": false,
                "processTimeOut": 30,
                "logFileName": "C:\\ProgramData\\Globalscape\\EFT Server\\Logs\\cmdout.log",
                "redirectOutputToClient": true,
                "useMinNumOfParams": false,
                "minNumOfParams": 1,
                "minNumOfParamsMsg": ""
            }
    }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 10
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/custom-commands/$customCommandID" -Method 'PATCH' -Headers $authHeader -Body $update

### DELETE CUSTOM COMMAND
#Get Site Custom Commands in order to get custom command id
Write-Output "Get Site Custom Commands in order to Delete"
Write-Output "-----"
$commands = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/custom-commands" -Method 'GET' -Headers $authHeader
#Write-Output $serverAdminDetails | ConvertTo-Json -Depth 10
foreach ($commands in $commands.id)
{
    Write-Output ("Custom Command found:  $($commands.id): $($commands.attributes.name)")
}
$customCommandID = $commands.data[0].id

Write-Output "Deleting Custom Command: "  $customCommandID
Write-Output "-----"
$commandList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/custom-commands/$customCommandID" -Method 'DELETE' -Headers $authHeader
Write-Output $commandList | ConvertTo-Json -Depth 10
